require 'spec_helper'

describe 'twitch_haproxy::global', :type => :define do
  let(:facts) do {
    :osfamily        => 'Debian',
    :lsbdistcodename => 'precise',
    :ipaddress       => '127.0.0.1',
    :concat_basedir  => '/var/lib/puppet/concat',
  }
  end

  context 'verify module' do
    let(:title) { 'mytest' }
    let(:params) do {
      :config_target    => '/tmp/haproxy/haproxy.cfg',
      :global_options   => {'key1' => 'one','key2' => 'two'},
      :defaults_options => {'key3' => 'three','key4' => 'four'},
    }
    end

    it 'does contain class concat' do
      should contain_concat(params[:config_target])
    end

    it 'does contain header for haproxy config' do
      should contain_concat__fragment("00-header-#{title}").with({
        :order => '01',
      })
    end

    it 'does contain global and defaults sections of config' do
      should contain_concat__fragment("haproxy-base-#{title}").with({
        :order => '10',
      })
    end

  end
end
