# Smoca Gnosis

Smoca Gnosis is a front end Rails application for the [Smoca Automation Framework](https://git-aws.internal.justin.tv/qa/smoca).
It currently provides metrics around usage patterns.

You can view it live at:
[http://smoca.internal.justin.tv/](http://smoca.internal.justin.tv/)

### Local Development

See [Local Development documentation](docs/local_development.md)

### Infrastructure

Smoca Gnosis is a Ruby on Rails Application. It's deployed via Elastic Beanstalk.

![Infrastructure Diagram](docs/images/infrastructure_diagram.png)

Its database is a MySQL hosted on AWS RDS.

### Running Tests

Run `bundle exec rspec`

To have tests run while developing, use

`bundle exec guard`

### Deployment

Gnosis is integrated into Skadi, our deploy tool. You can view it here:

[https://clean-deploy.internal.justin.tv/#/home/qa](https://clean-deploy.internal.justin.tv/#/home/qa)

_If you have trouble viewing this, you may need to be added to the qa org on github. Contact #qa-automation on Slack._

We currently only support one [environment](https://clean-deploy.internal.justin.tv/#/qa/gnosis/environments), smoca-gnosis-dev.
Only the master branch should be deployed to the environment.

#### Manual Elastic Beanstalk Deployment
This web application runs on Elastic Beanstalk within twitch-web-dev.

To do this, you must have access to twitch-web-dev. If you do not have access, ask #edge-infra in Slack.

##### First Time Initialization

If you need to make deploys, and haven't configured Elastic Beanstalk with Gnosis yet, **you must do this**.

Download Elastic Beanstalk CLI. See [AWS Documentation](http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/eb-cli3-install.html) for more details.

After configuring the CLI, in the repository...

Run `eb init`

For your application selection, choose `smoca-gnosis`. If that's not listed, check [the terraform configuration](terraform/beanstalk/main.tf) for the name.

If prompted, Run this using the appropriate version of Ruby & Rails, using Puma. At the time of this doc, it is `Ruby 2.3 (Puma)`

##### Environment Creation

**Note: This step likely isn't necessary.**

If the app environment is not yet created, you must create it.

To create an environment, run:

```
eb create smoca-gnosis-ENVIRONMENT -ip qa-prod-gnosis \
--envvars RDS_DB_NAME=gnosis,RDS_HOSTNAME=placeholder,RDS_USERNAME=placeholder,RDS_PASSWORD=placeholder,SECRET_KEY_BASE=placeholder
```

- Replace ENVIRONMENT with your environment suffix name (i.e., dev)
- Replace environment placeholder values with their proper value. RDS data can be obtained from AWS RDS Console.
- The `-ip` prefix adds the qa-prod-gnosis instance profile required for Sandstorm.

##### Deploying Code Changes

Commit your changes. Merge to master.

Run `eb deploy`

### Sandstorm Integration

Gnosis is integrated with [sandstorm-agent](https://git-aws.internal.justin.tv/systems/sandstorm-agent).
We use Sandstorm to store secrets, such as a database password.

Configuration files export on the box to `/etc/gnosis/config.yaml`.

To make changes to the template, you must:
1) Merge an update in [qa/scripts](https://git-aws.internal.justin.tv/qa/scripts)
2) Re-run environment creation

A better method is pending.
