# Poll function that ajax's the API, looking for buildID
jQuery ->
  poll = ->
    console.log 'Polling for build...'
    $.ajax
      url: "/api/build/#{recordID}"
      dataType: 'json'
      type: 'get'
      success: (data) ->

        if data.build_id
          console.log "Found build id #{data.build_id}"
          clearInterval pollInterval
          location.reload()
        else if data.cancelled == true
          console.log "Record was found cancelled. Aborting poll."
          clearInterval pollInterval
          location.reload()

  pendingSpinner = ->
    opts =
      position: 'absolute'
      top: '50%'
    target = document.getElementById('build')
    spinner = new Spinner(opts).spin(target)
    $('#build-name').text('Pending...')

  unless buildID || pending == false
    # Set the interval at which to run the poll() function
    pollInterval = setInterval((->
      poll()
    ), 5000)

    # Run poll() on initial page load, instead of waiting the 5 seconds for first poll
    pendingSpinner()
    poll()
    return

displayNotice = (message_text) ->
  $.notify { message: message_text},
    type: 'info'
    offset: 55
    delay: 5000
    placement:
      from: 'top'
      align: 'right'
    animate:
      enter: 'animated fadeInDown'
      exit: 'animated fadeOutUp'
$ ->
  unless Cookies.get('construction-alert-box') == 'closed'
    displayNotice("Pardon the dust! We're actively developing this page.")

  $('button.close').click ->
    console.log 'Dismissed Alert Box'
    Cookies.set('construction-alert-box', 'closed', { expires: 30 })
