// Ability to Show/Hide the Failed/Passed/Skipped Sections
function toggleListings(e) {
  var element = e.target;
  var down_glyph = 'glyphicon-menu-down';
  var up_glyph = 'glyphicon-menu-up';

  if (element.classList.contains(down_glyph)) {
    element.classList.remove(down_glyph);
    element.classList.add(up_glyph);
    element.setAttribute("title", "Show Section");
  } else {
    element.classList.remove(up_glyph);
    element.classList.add(down_glyph);
    element.setAttribute("title", "Hide Section");
  }
}

// Checks if the requests for all elements have been filled
function requests_complete(fail_line_el, ex_msg_el) {
  return fail_line_el.data('request_complete') == true && ex_msg_el.data('request_complete') == true
}

// Sets the exception data classes with text content
function setExceptionData(el, data) {
  if (el.data('request_complete') == true) {
    return; // Request was already complete, return
  }

  if (data) {
    el.text(data);
    el.data('request_complete', true); // Keep track if it's already filled this
  } else {
    el.text('No Data Available.');
  }
}

// Updates the Exception Data box with data
function updateExceptionData(el, result_id) {
  var url = ("/api/test_case_result/" + result_id);
  var $failing_line = el.find('.failing_line');
  var $exception_message = el.find('.exception_message');

  if (requests_complete($failing_line, $exception_message) == true) {
    return; // All elements had completed requests, nothing left to update
  }

  var xhr = new XMLHttpRequest();
  xhr.onload = function() {
    if(xhr.status == 200) {
      var responseObject = JSON.parse(xhr.responseText);
      setExceptionData($failing_line, responseObject.failing_line);
      setExceptionData($exception_message, responseObject.exception_message)
    }
  };

  xhr.open('GET', url, true);
  xhr.send(null);
}

// Displays the Exception Data Detail box, updates if necessary
function showDetail(e) {
  e.preventDefault(); // Don't follow the link click through
  e.target.blur(); // Remove the selection off the link
  var $element = $(e.target).closest('.test-case-listing');
  var $test_case_detail = $element.find('.test-case-detail');

  $test_case_detail.toggleClass('hidden');

  if (! $test_case_detail.hasClass('hidden')) {
    // If the el doesn't have the hidden class, it's opened, so update the data
    updateExceptionData($test_case_detail, e.target.dataset.resultId);
  }

  $close_el = $element.find('.quick-exception-view-close');
  $close_el.on('click', function(e) {
    $test_case_detail.addClass('hidden')
  });
}

// Wait for the DOM to load before trying to add listeners to elements
// Can't use DOMContentLoaded Due to TurboLinks
// Can't use Turbolinks page:load event, as that fires when leaving the page
var ready = function() {
  var el = document.getElementsByClassName('results-dropdown');
  // Add the event listener to all matching classes
  for (var i = 0; i < el.length; i++) {
    el[i].setAttribute("title", "Hide Section");
    el[i].addEventListener('click', function(e){
      toggleListings(e);
    }, false);
  }

  // Logic for Quick View
  var el = document.getElementById('failed').getElementsByClassName('test-case-listing-url');
  // Add the event listener to all matching classes
  for (var i = 0; i < el.length; i++) {
    el[i].addEventListener('click', function(e){
      showDetail(e);
    }, false);
  }
};

$(document).ready(ready);
