class Api::JenkinsBuildController < ApplicationController
  require 'jenkins_job_scraper'

  # Display data on a Jenkins Build
  # Expects a job name and build id
  def show
    jenkins_username = Rails.application.secrets.jenkins_username || ENV['JENKINS_USERNAME']
    jenkins_token    = Rails.application.secrets.jenkins_token    || ENV['JENKINS_TOKEN']

    scraper = JenkinsJobScraper.new(params[:job], jenkins_username, jenkins_token)
    @build = scraper.get_build_info(params[:id])
    
    if @build
      render json: @build
    else
      render json: {:error => 'not found'}.to_json, :status => 404
    end
  end
end
