class Api::QueueTimeController < ApplicationController
  skip_before_filter :verify_authenticity_token # Safe to skip, as no web form is attached to this

  # GET /api/queue_time_monitor
  def index
    if params[:complete] == 'true'
      records = QueueTimeMonitor.all.where.not(smoca_initiated_at: nil)
    elsif params[:complete] == 'false'
      records = QueueTimeMonitor.all.where(smoca_initiated_at: nil)
    else
      records = QueueTimeMonitor.all
    end

    render json: records
  end

  # POST /api/queue_time_monitor
  def create
    r = QueueTimeMonitor.new(permitted_params)

    if r.valid?
      r.save!
      QueueTimeMonitorJob.perform_async(r.id, permitted_params[:source_job_name], permitted_params[:source_build_number])
      render json: r
    else
      render json: {:error => r.errors.messages}.to_json, :status => 400
    end
  end

  private def permitted_params
    params.permit(:source_job_name, :source_build_number)
  end
end
