class SessionsController < ApplicationController
  skip_before_action :verify_authenticity_token

  include SessionsHelper

  # Log In
  def create
    auth =  request.env['omniauth.auth']
    user = User.sign_in_from_omniauth(auth)

    log_in(user.uid)
    redirect_back_or dashboard_path # Redirect user back to their original url, or the root url
  end

  # Log Out
  def destroy
    log_out
    redirect_to root_url
  end

  # Handles a failure when logging in to ldap
  def ldap_failure
    flash[:danger] = "Authentication failed because #{params[:message]}."
    redirect_to root_url
  end

end
