require 'sidekiq/web'
require 'sidekiq/cron/web'

Rails.application.routes.draw do
  root 'static_pages#home'
  get 'manage' => 'static_pages#manage'

  # Smoca Build
  resources :smoca_build
  get '/job/:job_name/:build_id' => 'smoca_build#show', as: :job_build
  get 'dashboard' => 'smoca_build#dashboard'
  post 'generate' => 'smoca_build#generate_job_data'
  get 'run' => 'smoca_build#new'
  post 'trigger_job' => 'smoca_build#trigger_job'

  resources :test_case_result
  get '/smoca_build/:id/test_cases'               => 'test_case_result#index'
  get '/smoca_build/:id/test_cases/:test_case_id' => 'test_case_result#show'

  # Authentication
  get '/login', to: redirect('/auth/ldap')
  post '/auth/ldap/callback', to: 'sessions#create'
  get '/auth/ldap/callback', to: 'sessions#create' # This is only called in test env

  delete '/logout', to: 'sessions#destroy'
  get '/auth/failure', to: 'sessions#ldap_failure'

  namespace :api do
    get '/jenkins_build/:job/:id' => 'jenkins_build#show'
    get '/browserstack/browsers'  => 'browserstack#show'

    get '/build/:id'                     => 'build#show'
    get '/build/job/:job_name/:build_id' => 'build#show'
    post '/build'                        => 'build#create'
    put '/build/:id'                     => 'build#update'

    get '/queue_time_monitor'     => 'queue_time#index'
    post '/queue_time_monitor'    => 'queue_time#create'

    get '/test_case_result/:id'   => 'test_case_result#show'
    post '/build/:id/test_cases'  => 'test_case_result#create'
  end

  mount Sidekiq::Web => '/sidekiq'
end
