# encoding: UTF-8
# This file is auto-generated from the current state of the database. Instead
# of editing this file, please use the migrations feature of Active Record to
# incrementally modify your database, and then regenerate this schema definition.
#
# Note that this schema.rb definition is the authoritative source for your
# database schema. If you need to create the application database on another
# system, you should be using db:schema:load, not running all the migrations
# from scratch. The latter is a flawed and unsustainable approach (the more migrations
# you'll amass, the slower it'll run and the greater likelihood for issues).
#
# It's strongly recommended that you check this file into your version control system.

ActiveRecord::Schema.define(version: 20170728232419) do

  create_table "delayed_jobs", force: :cascade do |t|
    t.integer  "priority",   limit: 4,     default: 0, null: false
    t.integer  "attempts",   limit: 4,     default: 0, null: false
    t.text     "handler",    limit: 65535,             null: false
    t.text     "last_error", limit: 65535
    t.datetime "run_at"
    t.datetime "locked_at"
    t.datetime "failed_at"
    t.string   "locked_by",  limit: 255
    t.string   "queue",      limit: 255
    t.datetime "created_at"
    t.datetime "updated_at"
  end

  add_index "delayed_jobs", ["priority", "run_at"], name: "delayed_jobs_priority", using: :btree

  create_table "queue_time_monitors", force: :cascade do |t|
    t.string   "source_job_name",     limit: 255
    t.string   "source_build_number", limit: 255
    t.string   "smoca_build_number",  limit: 255
    t.datetime "created_at",                      null: false
    t.datetime "updated_at",                      null: false
    t.datetime "smoca_initiated_at"
  end

  create_table "smoca_builds", force: :cascade do |t|
    t.string   "result",       limit: 255
    t.string   "developer",    limit: 255
    t.string   "environment",  limit: 255
    t.datetime "created_at",                                 null: false
    t.datetime "updated_at",                                 null: false
    t.datetime "initiated_at"
    t.string   "build_id",     limit: 255
    t.string   "job_name",     limit: 255
    t.string   "queue_id",     limit: 255
    t.boolean  "cancelled",                  default: false
    t.boolean  "pending",                    default: false
    t.text     "examples",     limit: 65535
  end

  create_table "test_case_results", force: :cascade do |t|
    t.string   "result",            limit: 255
    t.integer  "smoca_build_id",    limit: 4
    t.integer  "test_case_id",      limit: 4
    t.datetime "created_at",                      null: false
    t.datetime "updated_at",                      null: false
    t.string   "exception_class",   limit: 255
    t.text     "exception_message", limit: 65535
    t.string   "screenshot_url",    limit: 255
    t.text     "backtrace",         limit: 65535
    t.text     "failing_line",      limit: 65535
  end

  add_index "test_case_results", ["smoca_build_id"], name: "index_test_case_results_on_smoca_build_id", using: :btree
  add_index "test_case_results", ["test_case_id"], name: "index_test_case_results_on_test_case_id", using: :btree

  create_table "test_cases", force: :cascade do |t|
    t.string   "name",       limit: 255
    t.datetime "created_at",             null: false
    t.datetime "updated_at",             null: false
  end

  create_table "test_features", force: :cascade do |t|
    t.string   "project",    limit: 255
    t.string   "name",       limit: 255
    t.datetime "created_at",             null: false
    t.datetime "updated_at",             null: false
  end

  create_table "test_scenarios", force: :cascade do |t|
    t.string   "name",            limit: 255
    t.boolean  "active",                      default: true
    t.datetime "created_at",                                 null: false
    t.datetime "updated_at",                                 null: false
    t.integer  "test_feature_id", limit: 4
  end

  add_index "test_scenarios", ["test_feature_id"], name: "index_test_scenarios_on_test_feature_id", using: :btree

  create_table "users", force: :cascade do |t|
    t.string   "uid",        limit: 255
    t.string   "email",      limit: 255
    t.string   "provider",   limit: 255
    t.boolean  "admin",                  default: false
    t.datetime "created_at",                             null: false
    t.datetime "updated_at",                             null: false
    t.string   "name",       limit: 255
  end

  add_foreign_key "test_case_results", "smoca_builds"
  add_foreign_key "test_case_results", "test_cases"
end
