# API Endpoints

Note, the API is currently in an experimental format. It is not currently assigned versioning.

Root endpoint:

`/api`

### jenkins_build

Provides a wrapper around a Jenkins Build.

| Endpoint | Description |
| ---- | --------------- |
| GET /jenkins_build/:job/:id | Details of a Jenkins Build for the specified job and id |

**Example Response**
```json
{
  number: "2000",
  displayName: "qa-smoca #2000",
  result: "FAILURE",
  url: "https://jenkins.internal.justin.tv/job/qa-smoca/2000",
  timestamp: "1465522642130",
  initiatedBy: "tboyd",
  environment: "clean-staging-ffa-38",
  smoca_triggered: null,
  ldap: true
}
```

### build

Returns build results that exist within Smoca Gnosis' database. This does not poll the Jenkins API.

| Endpoint | Description |
| ------- | ------------ |
| GET /build/:id | Displays the details of a build from the Gnosis DB ID
| GET /build/search/:job/:id | Displays the details of a build. Look up from the job name, and the Jenkins build id of that job.
| POST /build | Create a new build. Returns that build
| PUT /build/:id | Updates a build with the parameters provided

**Example Response**
```json
{
  id: 1,
  result: "FAILURE",
  developer: "pestanoc",
  environment: "clean-staging-ffa-45",
  created_at: "2016-08-31T22:40:39.000Z",
  updated_at: "2016-08-31T22:54:40.000Z",
  initiated_at: "2016-08-31T17:37:19.000Z",
  build_id: "3174",
  job_name: "qa-smoca",
  queue_id: null
}
```

### browserstack/browsers

Returns the BrowserStack Supported Browsers in a re-arranged, less dense format.

| Endpoint | Description |
| ------- | ------------ |
| GET /browserstack/browsers | Displays all browser configurations

Supported Filter Parameters:

| Parameter | Description |
| ------- | ------------ |
| ?platform | The Base Platform to filter by. Windows, OS X, Linux.
| ?os | The operating system to filter by. 7, 8, 10, Snow Leopard, etc. Must include platform
| ?browser | The browser to filter by and retrieve an array of versions. Must include platform and os.

** Example Response **
```json

{
 "Windows": {
  "7": {
   "firefox": [
    "47.0",
    "48.0"
   ]
   "chrome": [
    "51.0",
    "52.0"
   ]
  }
  "8": {
    "firefox" [
      "47.0"
    ]
  }
 }
 "OS X": {
  "Snow Leopard": {
    "chrome": [
      "48.0",
      "49.0"
    ]
  }
 }
}
```
