This documentation covers how to set up your environment to run and develop for Gnosis.

## Local Set Up

### Prerequisites

Must have configured:

- Git
- Brew
- Rbenv

If you do not have these configured yet, try looking at the
[Smoca Preparing Your Environment](https://git-aws.internal.justin.tv/qa/smoca/blob/master/resources/docs/developing_for_smoca.md#preparing-your-environment)

### Configuration

##### Clone repository into directory of your choice.

`git clone git@git-aws.internal.justin.tv:qa/gnosis.git`

##### Install Ruby Version via Rbenv
```
rbenv install `cat .rbenv-version`
```

##### Install MySQL

`brew update`

`brew doctor`

`brew upgrade`

`brew install mysql`

##### Install Gems.

MySQL is required before this step (see above).

`bundle install`

##### Start MySQL

To run in the background,

`brew services start mysql`

For one-time:

`mysql.server start`

##### Install MySQL Timezone Support

`mysql_tzinfo_to_sql /usr/share/zoneinfo | mysql -u root mysql`

If you receive warnings, they likely can be ignored.

##### Install and Start Redis
`brew install redis`

To run in the background,

`brew services start redis`

For one-time:

`redis-server /usr/local/etc/redis.conf`

##### Prepare the Database

`bundle exec rake db:create`

`bundle exec rake db:migrate`

## Local Development

Start server:

`bundle exec rails s`

Consider starting Sidekiq if you'll be working with Cron Jobs. See [Worker Jobs documentation](worker_jobs.md)

Load Rails Console:

`bundle exec rails c`

or in sandbox:

`bundle exec rails c --sandbox`

Generating fake data:

`bundle exec rake db:seed`
