## Workers

Background worker jobs are supported through [Sidekiq][1].

The sidekiq dashboard can be viewed at /sidekiq.

Example: https://smoca.internal.justin.tv/sidekiq

#### Set Up

Sidekiq requires [redis-server](http://redis.io/) to be able to store jobs.

Install and run redis-server on your machine within [Local Development](local_development.md#install-and-start-redis)

#### Starting Sidekiq
To initiate Sidekiq, run:

`bundle exec sidekiq`

#### Adding a new job

To add a new worker job, place it in:
app/workers

Ensure your file name and class name ends in job.

You must also place `include Sidekiq::Worker` within the app.

Full example:
```
# app/workers/hard_worker_job.rb
class HardWorkerJob
  include Sidekiq::Worker
  
  def perform(*args)
    puts "My Job"
  end
end
```

These jobs can then be called in the controller via:

`HardWorkerJob.perform_now`

`HardWorkerJob.perform_async`

Additional examples can be found within the [Sidekiq Documentation][1]

## Cron Jobs

Gnosis supports cron jobs through [Sidekiq-cron](https://github.com/ondrejbartas/sidekiq-cron).

#### Adding a new cron job

Go through the steps of [adding a new job](#adding-a-new-job).

Then, add that job within config/cron_schedule.yml using [cron notation](http://www.nncron.ru/help/EN/working/cron-format.htm)

Reboot Sidekiq, and you should see that job at /sidekiq/cron


[1]: https://github.com/mperham/sidekiq