require 'rails_helper'

describe Api::BuildController, type: :controller do

  describe '#show' do

    let(:build) { FactoryGirl.create(:smoca_build) }

    describe 'lookup by id' do

      it 'returns 200 and data if build was found' do
        get :show, :id => build.id
        expect(response).to have_http_status 200
        validate_response(response, build)
      end

      it 'returns 404 if build was not found' do
        get :show, :id => '838638683'
        expect(response).to have_http_status 404
        body = JSON.parse(response.body)
        expect(body[:error]).to eq('not found')
      end

    end

    describe 'lookup by job_name and build_id' do

      it 'returns 200 and data if build was found' do
        get :show, :job_name => build.job_name, :build_id => build.build_id
        expect(response).to have_http_status 200
        validate_response(response, build)
      end

      it 'returns 404 if build was not found' do
        get :show, :job_name => 'foobar', :build_id => '385638683'
        expect(response).to have_http_status 404
        body = JSON.parse(response.body)
        expect(body[:error]).to eq('not found')
      end

    end

    def validate_response(response, object)
      body = JSON.parse(response.body)
      expect(body['id']).to        eq(object.id)
      expect(body['job_name']).to  eq(object.job_name)
      expect(body['build_id']).to  eq(object.build_id)
      expect(body['developer']).to eq(object.developer)
    end
  end
end
