require 'faker'

FactoryGirl.define do
  sequence(:build_id) { |n| n } # Unique ids for build id

  factory :smoca_build do |f|
    build_id
    f.initiated_at { Faker::Time.between(DateTime.now - 30, DateTime.now) }
    f.result 'Success'
    f.developer { Faker::Name.name }
    f.environment { "clean-staging-ffa-#{rand(30)}" }
    f.job_name 'qa-smoca'
  end
end
