require 'rails_helper'

describe TestCase, type: :model do
  it 'has a valid factory' do
    expect(FactoryGirl.create(:test_case)).to be_valid
  end

  describe 'name' do
    subject { test_case.valid? }

    context 'when included' do
      let(:test_case) { FactoryGirl.build(:test_case, name: 'A test case') }
      it { should be_truthy }
    end

    context 'when not included' do
      let(:test_case) { FactoryGirl.build(:test_case, name: nil) }
      it { should be_falsey}
    end

    context 'when blank' do
      let(:test_case) { FactoryGirl.build(:test_case, name: '   ') }
      it { should be_falsey }
    end

    it 'fails when duplicated' do
      name = 'My Non Unique Test Case'
      case1 = FactoryGirl.create(:test_case, name: name)

      case2 = FactoryGirl.build(:test_case, name: name)
      expect(case2).not_to be_valid
    end
  end
end
