require 'rails_helper'

describe TestFeature, type: :model do

  describe 'project' do
    subject { feature.valid? }

    context 'when not included' do
      let(:feature) { FactoryGirl.build(:test_feature, project: nil) }
      it { should be_falsey }
    end

    context 'when blank' do
      let(:feature) { FactoryGirl.build(:test_feature, project: '  ')}
      it { should be_falsey }
    end

    context 'when included' do
      let(:feature) { FactoryGirl.build(:test_feature, project: 'My Project') }
      it { should be_truthy }
    end

    it "doesn't need to be unique" do
      project = 'foobar'
      FactoryGirl.create(:test_feature, project: project, name: 'feature 1')
      non_unique_record = FactoryGirl.build(:test_feature, project: project, name: 'feature 2')
      expect(non_unique_record).to be_valid
    end
  end

  describe 'name' do
    subject { feature.valid? }

    context 'when not included' do
      let(:feature) { FactoryGirl.build(:test_feature, name: nil) }
      it { should be_falsey }
    end

    context 'when included' do
      let(:feature) { FactoryGirl.build(:test_feature, name: 'my feature') }
      it { should be_truthy }
    end

    context 'when blank' do
      let(:feature) { FactoryGirl.build(:test_feature, name: '  ')}
      it { should be_falsey }
    end


    it 'fails if already taken' do
      name = 'foobar'
      FactoryGirl.create(:test_feature, name: name)
      non_unique_record = FactoryGirl.build(:test_feature, name: name)
      expect(non_unique_record).not_to be_valid
    end

    it 'passes if unique' do
      FactoryGirl.create(:test_feature, name: 'foobar')
      unique_record = FactoryGirl.build(:test_feature, name: 'foobar unique')
      expect(unique_record).to be_valid
    end
  end
end
