require 'rails_helper'

RSpec.describe TestScenario, type: :model do

  describe 'active status' do
    subject { scenario.active? }

    context 'when not specified' do
      let(:scenario) { FactoryGirl.create(:test_scenario, active: '') }
      it { should be_falsey }
    end

    context 'when specified as false' do
      let(:scenario) { FactoryGirl.create(:test_scenario, active: false) }
      it { should be_falsey }
    end

    context 'when specified as true' do
      let(:scenario) { FactoryGirl.create(:test_scenario, active: true) }
      it { should be_truthy }
    end
  end

  describe 'name' do
    subject { scenario.valid? }

    context 'when not provided' do
      let(:scenario) { FactoryGirl.build(:test_scenario, name: nil) }
      it { should be_falsey }
    end

    context 'when blank' do
      let(:scenario) { FactoryGirl.build(:test_scenario, name: '    ') }
      it { should be_falsey }
    end

    context 'when provided' do
      let(:scenario) { FactoryGirl.build(:test_scenario, name: 'my test scenario') }
      it { should be_truthy }
    end

    context 'when two scenarios have the same name' do
      scenario_name = 'foo test'
      FactoryGirl.create(:test_scenario, name: scenario_name)
      let(:scenario) { FactoryGirl.build(:test_scenario, name: scenario_name)}

      it { should be_truthy }
    end
  end
end
