require 'rails_helper'

RSpec.describe 'Page Authentication Tests', type: :request do
  describe 'GET #manage' do
    it 'redirects to log in page when logged out' do
      get manage_path
      expect(response).to redirect_to login_path
    end

    it 'does not redirect when logged in' do
      log_in_as('foobar')
      get manage_path
      expect(response).not_to redirect_to login_path
      expect(response.status).to eq(200)
    end
  end
end
