require 'rails_helper'

RSpec.describe 'Trigger Build', type: :request do
  describe 'Accessing the page' do
    it 'requires authentication when logged out' do
      get new_smoca_build_path
      expect(response).to redirect_to login_path
      log_in_as('foobar')
      expect(response).to redirect_to new_smoca_build_path
    end

    it "doesn't request log in when already logged in" do
      log_in_as('foobar')
      get new_smoca_build_path
      expect(response).not_to redirect_to login_path
      expect(response.status).to eq(200)
    end
  end
end
