require 'rails_helper'

RSpec.describe 'User Log In', type: :request do
  describe 'Logging in' do
    it 'updates header with user name' do
      username = 'foobar'
      log_in_as(username)
      expect(response).to redirect_to dashboard_path

      get root_path
      assert_select 'nav' do
        assert_select 'a[href=?]', logout_path
        # Logged in user appears on top bar
        assert_select 'a.dropdown-toggle', text: username
      end
    end
  end

  describe 'Logging out' do
    it 'removes username from header' do
      username = 'foobar'
      log_in_as(username)

      # Log Out
      delete logout_path

      get root_path
      assert_select 'nav' do
        assert_select 'a[href=?]', login_path
        # Logged in user appears on top bar
        assert_select 'a.dropdown-toggle', {count: 0, text: username}
      end
    end
  end
end
