def log_in_as(user, opts={})
  return false unless Rails.env.test?

  OmniAuth.config.test_mode = true

  OmniAuth.config.mock_auth[:ldap] = OmniAuth::AuthHash.new({
      :provider => 'ldap',
      :uid => user,
      :extra => {:raw_info => {:uid => [user]}},
      :info => {:email => 'foo@bar.com'}
                                                            })

  if opts.dig(:capybara)
    visit login_path
  else
    # Non-Capybara test
    post auth_ldap_callback_path # Mock Logging In
  end
end
