#!/bin/bash
set -euo pipefail

OUTPUT_PATH=out
VPC=vpc-230f5e46
SUBNET=subnet-b0af88d5
SECURITY_GROUP=sg-c06b03a4

packer \
    -machine-readable build                    \
    -var "vpc_id=${VPC}"                       \
    -var "subnet_id=${SUBNET}"                 \
    -var "security_group_id=${SECURITY_GROUP}" \
    base.json | tee ${OUTPUT_PATH}/build.log

AMIREF=`grep 'amazon-ebs,artifact,0,id,' ${OUTPUT_PATH}/build.log`
echo ${AMIREF##*:} > ${OUTPUT_PATH}/amireference
