#!/bin/bash
set -e -x

## install necessary packages
sudo yum -y install nss-pam-ldapd pam_ldap openssh-ldap gcc openldap-devel
sudo pip install ssh-ldap-pubkey

# run authconfig to do initial setup
sudo authconfig --enableldap --enableldapauth --enablemkhomedir --enablelocauthorize --enablecache --updateall

# ldap configs
sudo cp /tmp/files/ldap/ldap.conf /etc/pam_ldap.conf
sudo ln -sf /etc/pam_ldap.conf /etc/ldap.conf
sudo ln -sf /etc/pam_ldap.conf /etc/openldap/ldap.conf

# ssh configs
sudo cp /tmp/files/ldap/sshd_config /etc/ssh/sshd_config

# nslcd configs
sudo cp /tmp/files/ldap/nslcd.conf /etc/nslcd.conf

# nsswitch configs
sudo cp /tmp/files/ldap/nsswitch.conf /etc/nsswitch.conf

# sudoers config
sudo cp /tmp/files/ldap/twitch-sudoers /etc/sudoers.d/twitch-ldap
sudo chmod 440 /etc/sudoers.d/twitch-ldap

# ensure nslcd and nscd are on
sudo chkconfig nslcd on
sudo chkconfig nscd on

# fixup the ssh ldap pubkey tool
sudo sed -i 's/ssh-ldap-pubkey list/\/usr\/local\/bin\/ssh-ldap-pubkey list/' /usr/local/bin/ssh-ldap-pubkey-wrapper
