# Android Page Files
require_relative('../../android/pages/channel_directory_page')
require_relative('../../android/pages/game_directory_page')
require_relative('../../android/pages/channel_page')
require_relative('../../android/pages/chat_page')
require_relative('../../android/pages/login_page')
require_relative('../../android/pages/search_page')
require_relative('../../android/pages/following_page')
require './pages/components/player'

module Helpers
  module PageHelper
    class << self

      attr_accessor :android_debug

      def initialize_android_variables
        @android_debug = 'tv.twitch.android.debug:id'
        channel_page.initialize_android_channel_page_variables
        channel_directory.initialize_android_channel_directory_variables
        game_directory.initialize_android_game_directory_variables
        search_page.initialize_android_search_page_variables
        chat_page.initialize_android_chat_variables
        login_page.initialize_android_login_variables
        following_page.initialize_android_following_variables

      end
    end
  end
end

module Kernel
  def page_helper
    Helpers::PageHelper
  end
end
