module Pages
  module ChannelDirectory
    class << self

      attr_accessor :top_channel, :channels_directory, :channels_directory_heading, :channels_directory_landing

      def initialize_android_channel_directory_variables
        # Via left nav
        @channels_directory = 'Channels'

        # Contained within Channels Directory
        @top_channel = page_helper.android_debug + '/channel_title'
        @channels_directory_heading = page_helper.android_debug + '/actionBar'
        @channels_directory_landing = page_helper.android_debug + '/landing_layout'
      end

      def has_text(text)
        wait {text_exact text}
      end
    end
  end
end

module Kernel
  def channel_directory
    Pages::ChannelDirectory
  end
end
