require_relative '../spec/requires'

module Pages
  module ChannelPage
    class << self

      attr_accessor :player, :channels_directory

      def initialize_android_channel_page_variables
        # Via left nav
        @channels_directory = '//android.widget.LinearLayout[1]/android.widget.FrameLayout[1]/android.widget.LinearLayout[1]/android.widget.FrameLayout[1]/android.support.v4.widget.DrawerLayout[1]/android.widget.LinearLayout[2]/android.support.v7.widget.RecyclerView[1]/android.widget.LinearLayout[3]'

        # Contained within Channel Page
        @player = page_helper.android_debug + '/player'
      end

      def visit_top_channel
        wait{xpath(channel_page.channels_directory).displayed?}
        xpath(channel_page.channels_directory).click
        find(channel_directory.top_channel).click
      end

      def visit_test_channel
        wait{find(search_page.nav_search_button).displayed?}
        find(search_page.nav_search_button).click
        wait{find(search_page.nav_search_text_area).displayed?}
        find(search_page.nav_search_text_area).send_keys 'twitchmedia2'
        xpath(search_page.channels_filter).click
        find(search_page.top_channel_search_result).displayed?
        find(search_page.top_channel_search_result).click
        find(search_page.channel_thumbnail).click
      end

      def visit_top_vod
        # Wait for Games directory button in left nav to show up after edge-swiping to reveal nav.
        wait{find(game_directory.games_directory).displayed?}
        find(game_directory.games_directory).click
        find(game_directory.top_game).click
        sleep(1)
        xpath(game_directory.past_broadcasts_filter).click
        find(game_directory.top_past_broadcast_thumbnail).click
      end
    end
  end
end

module Kernel
  def channel_page
    Pages::ChannelPage
  end
end
