module Pages
  module ChatPage
    class << self

      attr_accessor :chat_title, :chat_window, :chat_text_area, :chat_input, :chat_send, :chat_message

      def initialize_android_chat_variables
        # Contained within Chat area of Channel page
        # Chat area title "Chat"
        @chat_title = page_helper.android_debug + '/header'
        # Area where chat messages are viewed
        @chat_window = page_helper.android_debug + '/chat_message_list'
        # Area where user can input chat/emotes
        @chat_text_area = page_helper.android_debug + '/input_container'
        # Text area to type chat
        @chat_input = page_helper.android_debug + '/chat_input'
        # Send button
        @chat_send = page_helper.android_debug + '/chat_send'
        #First chat message
        @chat_message = '//android.widget.LinearLayout[1]/android.widget.FrameLayout[1]/android.widget.LinearLayout[1]/android.widget.FrameLayout[1]/android.support.v4.widget.DrawerLayout[1]/android.widget.LinearLayout[1]/android.widget.FrameLayout[1]/android.widget.FrameLayout[1]/android.widget.LinearLayout[1]/android.widget.RelativeLayout[1]/android.widget.FrameLayout[1]/android.widget.FrameLayout[1]/android.widget.LinearLayout[1]/android.widget.FrameLayout[1]/android.widget.FrameLayout[1]/android.widget.FrameLayout[1]/android.widget.LinearLayout[1]/android.widget.FrameLayout[2]/android.widget.ListView[1]/android.widget.TextView[2]'
      end

      def verify_chat_present
        wait{find(chat_title).displayed?}
        expect(find(chat_title).displayed?).to be_true
        expect(find(chat_window).displayed?).to be_true
        expect(find(chat_text_area).displayed?).to be_true
      end
    end
  end
end

module Kernel
  def chat_page
    Pages::ChatPage
  end
end
