module Pages
  module FollowingPage
    class << self

      attr_accessor :following_directory, :following_nav_bar, :followed_channels, :following_count

      def initialize_android_following_variables
        # Via left nav
        following_left_nav = '//android.widget.LinearLayout[1]/android.widget.FrameLayout[1]/android.widget.LinearLayout[1]/android.widget.FrameLayout[1]/android.support.v4.widget.DrawerLayout[1]/'
        @following_directory = following_left_nav + 'android.widget.LinearLayout[2]/android.support.v7.widget.RecyclerView[1]/android.widget.LinearLayout[5]'

        # Contained within Following Directory
        @following_nav_bar = following_left_nav + '/android.widget.LinearLayout[1]/android.widget.FrameLayout[1]/android.widget.LinearLayout[1]/android.view.ViewGroup[1]/android.widget.TextView[1]'
        following_directory_content = '//android.widget.LinearLayout[1]/android.widget.FrameLayout[1]/android.widget.LinearLayout[1]/android.widget.FrameLayout[1]/android.widget.FrameLayout[1]/android.widget.LinearLayout[1]'
        @followed_channels = '//android.widget.TextView[@text="Channels"]'
        @following_count = following_directory_content + '/android.support.v4.view.ViewPager[1]/android.widget.FrameLayout[1]/android.support.v7.widget.RecyclerView[1]/android.widget.FrameLayout[2]'
      end
    end
  end
end

module Kernel
  def following_page
    Pages::FollowingPage
  end
end
