module Pages
  module GameDirectory
    class << self

      attr_accessor :top_game, :past_broadcasts_filter, :top_past_broadcast_thumbnail, :games_directory, :game_nav_bar,
                    :nav_game_name, :top_game_channel

      def initialize_android_game_directory_variables
        # Via left nav
        @games_directory = page_helper.android_debug + '/browse_item'

        # Contained within Games Directory
        game_directory_landing = '//android.widget.LinearLayout[1]/android.widget.FrameLayout[1]/android.widget.LinearLayout[1]/android.widget.FrameLayout[1]/android.support.v4.widget.DrawerLayout[1]/android.widget.LinearLayout[1]/android.widget.FrameLayout[1]/android.widget.LinearLayout[1]'
        @top_game = page_helper.android_debug + '/game_name'
        @game_nav_bar = page_helper.android_debug + '/actionBar'
        @nav_game_name = game_directory_landing + '/android.view.ViewGroup[1]/android.widget.TextView[1]'

        # Contained within Past Broadcasts
        @top_past_broadcast_thumbnail = page_helper.android_debug + '/vod_thumbnail'
        @past_broadcasts_filter = game_directory_landing + '/android.widget.FrameLayout[1]/android.widget.FrameLayout[1]/android.widget.LinearLayout[1]/android.widget.HorizontalScrollView[1]/android.widget.LinearLayout[1]/android.widget.TextView[2]'

        # Top channel via Games Directory
        @top_game_channel = page_helper.android_debug + '/stream_thumbnail'
      end

      def first_cell
        @found_cell = wait {text 2}
        self
      end

      def title
        @found_cell.name.split(',').first
      end

      def click
        @found_cell.click
      end

      def dismiss_live_notifications
        wait{text('Turn Off').click}
      end
    end
  end
end

module Kernel
  def game_directory
    Pages::GameDirectory
  end
end
