module Pages
  module LoginPage
    class << self

      attr_accessor :left_nav_login_element, :username_field, :password_field, :password_text, :login_button,
                    :logout_button, :logout_confirmation, :logout_confirmation_button, :nav_username

      def initialize_android_login_variables
        # Contained within left nav
        @left_nav_login_element = page_helper.android_debug + '/login_button'
        @logout_button = page_helper.android_debug + '/logout_button'
        @nav_username = page_helper.android_debug + '/user_name'

        # Passport webview elements
        passport_webview = '//android.widget.LinearLayout[1]/android.widget.FrameLayout[1]/android.widget.LinearLayout[1]/android.widget.FrameLayout[1]/android.webkit.WebView[1]/android.webkit.WebView[1]/android.view.View[1]/android.view.View[2]'
        @username_field = passport_webview + '/android.view.View[2]/android.widget.EditText[1]'
        @password_field = passport_webview + '/android.view.View[4]/android.widget.EditText[1]'
        @password_text = passport_webview + '/android.view.View[3]'
        @login_button = passport_webview + '/android.view.View[6]/android.widget.Button[1]'

        # Pop up notification
        @logout_confirmation = '//android.widget.FrameLayout[1]/android.widget.FrameLayout[1]/android.widget.LinearLayout[1]/android.widget.FrameLayout[1]/android.widget.ScrollView[1]/android.widget.LinearLayout[1]/android.widget.TextView[1]'
        @logout_confirmation_button = '//android.widget.FrameLayout[1]/android.widget.FrameLayout[1]/android.widget.LinearLayout[1]/android.widget.LinearLayout[1]/android.widget.Button[2]'
      end

      def nav_login(username)
        wait{find(left_nav_login_element).click}

        wait{xpath(username_field).displayed?}
        xpath(username_field).send_keys(username)

        xpath(password_text).click
        wait{xpath(password_field).displayed?}
        xpath(password_field).click
        xpath(password_field).send_keys("L3tsTw1tch")
        xpath(password_text).click

        xpath(login_button).click
      end

      def logout
        open_nav

        find(logout_button).click
        wait{xpath(logout_confirmation).displayed?}
      end
    end
  end
end

module Kernel
  def login_page
    Pages::LoginPage
  end
end
