require_relative 'requires'

username = 'qa_moba'

describe 'User can use chat to' do

  after(:each) do
    back
    sleep(1)
  end

  it 'view chat on live video' do
    channel_page.visit_top_channel
    expect(find(chat_page.chat_window).displayed?).to be_true
  end

  it 'chat on live video' do
    login_page.nav_login(username)

    game_directory.dismiss_live_notifications

    channel_page.visit_test_channel

    chat_test_text = 'test text'
    find(chat_page.chat_input).send_keys chat_test_text
    find(chat_page.chat_send).click
    hide_keyboard

    wait{xpath(chat_page.chat_message).displayed?}
    expect(xpath(chat_page.chat_message).text).to eq "#{username}: #{chat_test_text}"
  end
end
