require_relative 'requires'

describe 'Channels Directory' do


  it 'loads correctly' do
    text(channel_directory.channels_directory).click

    wait{expect(find(channel_directory.channels_directory_heading).displayed?).to be_true}
    wait{expect(find(channel_directory.channels_directory_landing).displayed?).to be_true}
    expect(find(channel_directory.top_channel).displayed?).to be_true #finds top channel in the directory landing
  end

  it 'can tap on a channel' do
    channel_page.visit_top_channel

    wait{expect(find(chat_page.chat_window).displayed?).to be_true}
    back
    sleep(1)
  end
end

describe 'Games Directory' do

  it 'loads correctly' do
    find(game_directory.games_directory).click
    wait{find(game_directory.game_nav_bar).displayed?}

    expect(find(game_directory.top_game).displayed?).to be_true # finds top game in directory landing
  end

  it 'Can tap on a game' do
    find(game_directory.games_directory).click
    wait{find(game_directory.top_game).displayed?}
    top_game_text = find(game_directory.top_game).text
    find(game_directory.top_game).click
    wait{find(game_directory.game_nav_bar).displayed?}
    expect(xpath(game_directory.nav_game_name).text).to eq top_game_text
  end

  it 'can tap on a channel' do
    wait{find(game_directory.games_directory).displayed?}
    find(game_directory.games_directory).click

    wait{find(game_directory.top_game).displayed?}
    find(game_directory.top_game).click

    wait{find(game_directory.top_game_channel).displayed?}
    find(game_directory.top_game_channel).click

    wait{expect(find(chat_page.chat_window).displayed?).to be_true}
    back
    sleep(1)
  end
end
