require 'yaml'

class DriverConfig

  class << self

    def capabilities
      properties = get_config

      capabilities = {
        caps:
          {
            platformName: ENV['PLATFORM_NAME'] || properties['platformName'],
            platformVersion: ENV['PLATFORM_VERSION'] || properties['platformVersion'],
            deviceName: ENV['DEVICE_NAME'] || properties['deviceName'],
            browserName: ENV['BROWSER_NAME'] || properties['browserName'],
            avd: properties['avd'],
          }
      }

      if properties.has_key?('avd')
        capabilities[:caps][:avd] = properties['avd']
      end

      return capabilities
    end

    private def get_config
      config_path = File.read( Dir.pwd + '/config.yaml')
      return YAML.load(config_path)
    end

    private def app_directory
      return Dir.pwd + '/app/'
    end
  end
end
