require 'rspec'
require 'rspec/expectations'
require 'appium_lib'
require 'rubygems'
require_relative 'driver_config'
require 'rspec/retry'
require 'appium_capybara'
require 'capybara'
require 'capybara/dsl'
require 'capybara/rspec/matchers'

url = "http://localhost:4723/wd/hub" # This can be changed to saucelabs url.

Capybara.register_driver(:appium) do |app|
  appium_lib_options = {
    server_url: url
  }
  Appium::Capybara::Driver.new app, DriverConfig.capabilities # Default to Andorid 7.1.1
end

Capybara.default_driver = :appium

RSpec.configure do |config|

  config.include Capybara::DSL
  config.include Capybara::RSpecMatchers
  config.include RSpec::Matchers

  # Rspec retry

  config.verbose_retry = true   # Print retry status
  config.display_try_failure_messages = true    # Print failure
  config.default_retry_count = 3    # Retry 3 times
end

Capybara.app_host = 'http://betaplayer.twitch.tv'

def take_screenshot
  Dir.chdir("../Screenshots")
  screenshots_directory = Dir.pwd
  screenshot_path = screenshots_directory + '/error' + Time.now.strftime("%s") + '.png'
  screenshot(screenshot_path)
  puts screenshot_path
end
