# Page Files
require_relative('../pages/channel_directory_page')
require_relative('../pages/game_directory_page')
require_relative('../pages/channel_page')
require_relative('../pages/chat_page')
require_relative('../pages/login_page')
require_relative('../pages/search_page')
require_relative('../pages/following_page')
require './pages/components/pulse'

module Pages
  module PageHelper
    class << self

      attr_reader :status_bar

      def initialize_ios_variables
        @status_bar = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[3]/XCUIElementTypeStatusBar[1]'
        channel_page.initialize_ios_channel_page_variables
        channel_directory.initialize_ios_channel_directory_variables
        game_directory.initialize_ios_game_directory_variables
        search_page.initialize_ios_search_variables
        chat_page.initialize_ios_chat_variables
        login_page.initialize_ios_login_variables
        following_page.initialize_ios_following_variables
        pulse.initialize_ios_pulse_variables
      end
    end
  end
end

module Kernel
  def page_helper
    Pages::PageHelper
  end
end
