module Pages
  module ChannelDirectory
    class << self

      attr_accessor :channels_directory, :past_broadcast, :top_channel, :channels_nav_bar, :next_page_channel,
                    :last_channel, :broadcast_type, :past_broadcast_container, :top_past_broadcast,
                    :top_past_broadcast_views_duration, :top_channel_vod

      def has_text(text)
        wait {text_exact text}
      end

      def initialize_ios_channel_directory_variables
        # Contained in Channels directory
        @channels_directory = '//XCUIElementTypeStaticText[@name="Channels"]'
        @top_channel = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeTable[1]/XCUIElementTypeCell[1]'
        @next_page_channel = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeTable[1]/XCUIElementTypeCell[4]'
        @last_channel = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeTable[1]/XCUIElementTypeCell[3]'

        # Game broadcast type
        @past_broadcast = '//XCUIElementTypeOther[@name="Past Broadcasts"]'

        # Contained in Past Broadcast Container
        @top_past_broadcast = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeTable[1]/XCUIElementTypeCell[1]/XCUIElementTypeStaticText[2]'
        @top_channel_vod = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeCollectionView[1]/XCUIElementTypeCell[1]'
        @top_past_broadcast_views_duration = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeTable[1]/XCUIElementTypeCell[1]/XCUIElementTypeStaticText[3]'
        @channels_nav_bar = '//XCUIElementTypeNavigationBar[@name="Channels"]'
      end
    end
  end
end

module Kernel
  def channel_directory
    Pages::ChannelDirectory
  end
end
