require './spec/requires'

module Pages
  module ChannelPage
    class << self

      attr_accessor :channel_activity, :top_channel, :play_pause_button, :elapsed_time, :remaining_time, :player_container,
      :player_settings, :profile_button, :top_channel_name, :profile_image, :profile_nav_bar, :vod_duration_views,
      :audio_only_button, :apply_settings_button, :audio_only_state, :audio_only_toggle, :chat_only_state,
      :chat_only_toggle, :report_issue_button, :report_issue_menu_nav_bar, :fullscreen_button, :directory_vod_duration_views,
      :replay_vod_image, :fullscreen_player, :top_channel_static_text, :channel_name, :options_nav_bar, :chat_only_button,
      :report_production_issue, :reported_issue_confirmation, :send_issue_button, :vod_info

      # Visit top channel via channels directory
      def visit_top_channel
        wait{xpath(channel_directory.channels_directory).displayed?}
        xpath(channel_directory.channels_directory).click
        wait{xpath(top_channel).displayed?}
        @top_channel_name = xpath(top_channel_static_text).name
        xpath(top_channel).click
      end

      # Visit top vod via games directory
      def visit_top_vod
        xpath(game_directory.games_directory).click
        wait{xpath(game_directory.top_game).click}
        wait{xpath(channel_directory.past_broadcast).click}
        wait{xpath(channel_directory.top_past_broadcast_views_duration)}

        @directory_vod_duration_views = xpath(channel_directory.top_past_broadcast_views_duration).name
        wait{xpath(channel_directory.top_past_broadcast).click}
      end

      # Visit test channel via search
      def visit_test_channel
        test_channel = 'twitchmedia2'
        wait{xpath(search_page.search_box).displayed?}
        xpath(search_page.search_box).click
        wait{xpath(search_page.search_box).displayed?}
        xpath(search_page.search_box).send_keys test_channel
        wait{xpath(search_page.test_channel_result).displayed?}
        xpath(search_page.test_channel_result).click
      end

      def initialize_ios_channel_page_variables
        #Channel Page
        @channel_activity = '//XCUIElementTypeButton[@name="Channel Activity"]'
        @vod_info = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeTable[1]/XCUIElementTypeCell[1]'
        @vod_duration_views = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeTable[1]/XCUIElementTypeCell[1]/XCUIElementTypeStaticText[3]'

        @audio_only_state = '//XCUIElementTypeStaticText[@name="Audio Only"]'
        @audio_only_toggle = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[3]/XCUIElementTypeSwitch[1]'
        @chat_only_state = '//XCUIElementTypeStaticText[@name="Chat Only"]'
        @chat_only_toggle = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[3]/XCUIElementTypeSwitch[1]'
        @reported_issue_confirmation = '//XCUIElementTypeImage[@name="alert_overlay_check"]'

        # Top channel via channels directory
        @top_channel = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeTable[1]/XCUIElementTypeCell[1]'
        @top_channel_static_text = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeTable[1]/XCUIElementTypeCell[1]/XCUIElementTypeStaticText[1]'

        # Profile Page
        @profile_image = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeScrollView[1]/XCUIElementTypeOther[1]/XCUIElementTypeImage[1]'

        # Player Container
        @player_container = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]'
        @fullscreen_player = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeScrollView[1]/XCUIElementTypeOther[1]'

        # Player-ui
        @play_pause_button = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[3]/XCUIElementTypeButton[1]'
        @elapsed_time = player_container + '/XCUIElementTypeOther[3]/XCUIElementTypeOther[1]/XCUIElementTypeStaticText[1]'
        @remaining_time = player_container + '/XCUIElementTypeOther[3]/XCUIElementTypeOther[1]/XCUIElementTypeStaticText[2]'
        @player_settings = '//XCUIElementTypeButton[@name="Video options"]'
        @profile_button = '//XCUIElementTypeButton[@name="Profile"]'
        @seek_slider = '/XCUIElementTypeSlider[1]'
        @replay_vod_image = '//XCUIElementTypeImage[@name="glyph_playbackhud_resume"]'
        @channel_name = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeStaticText[2]'
        @fullscreen_button = '//XCUIElementTypeButton[@name="Expand / reduce video"]'

        # Player settings
        @options_nav_bar = '//XCUIElementTypeNavigationBar[@name="Options"]'
        @broadcast_options_text = '//XCUIElementTypeStaticText[@name="BROADCAST VIDEO & AUDIO OPTIONS..."]'
        @audio_only_button = '//XCUIElementTypeStaticText[@name="Audio Only"]'
        @apply_settings_button = '//XCUIElementTypeButton[@name="Apply"]'
        @chat_only_button = '//XCUIElementTypeStaticText[@name="Chat Only"]'
        @report_issue_button = '//XCUIElementTypeStaticText[@name="Report An Issue"]'
        @report_issue_menu_nav_bar = '//XCUIElementTypeStaticText[@name="Report Issue"]'
        @report_production_issue = '//XCUIElementTypeStaticText[@name="Production issue"]'
        @send_issue_button = '//XCUIElementTypeButton[@name="Send"]'
      end
    end
  end
end

module Kernel
  def channel_page
    Pages::ChannelPage
  end
end
