require './spec/requires'

module Components
  module Pulse
    class << self

      attr_reader :most_recent_post, :channel_feed_title, :channel_feed_switch, :post_pulse_update,
      :post_pulse_textarea, :new_pulse_post_nav, :post_pulse_button, :most_recent_post_text, :like_button,
      :delete_button

      def initialize_ios_pulse_variables
        @most_recent_post = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeTable[1]/XCUIElementTypeCell[2]'
        @channel_feed_title = '//XCUIElementTypeStaticText[@name="Channel Feed"]'
        @channel_feed_switch = '//XCUIElementTypeSwitch[@name="Channel Feed, BETA"]'
        @post_pulse_update = '//XCUIElementTypeButton[@name="Post an update to your channel…"]'
        @post_pulse_textarea = '//XCUIElementTypeTextView[@name="Chat Input"]'
        @new_pulse_post_nav = '//XCUIElementTypeStaticText[@name="New Post"]'
        @post_pulse_button = '//XCUIElementTypeButton[@name="Post"]'
        @most_recent_post_text = most_recent_post + '/XCUIElementTypeStaticText[1]'
        @like_button = '//XCUIElementTypeButton[@name="Endorse Button"]'
        @delete_button = '//XCUIElementTypeButton[@name="glyph trash"]'
      end

      def visit_my_pulse
        wait{xpath(login_page.logged_in_username).click}
      end
    end
  end
end

module Kernel
  def pulse
    Components::Pulse
  end
end
