module Pages
  module FollowingPage
    class << self

      attr_accessor :following_nav_bar, :followed_channels, :followed_channel

      def initialize_ios_following_variables
        @following_nav_bar = '//XCUIElementTypeNavigationBar[@name="Following"]'

        # Accessible via Following Directory
        @followed_channels = '//XCUIElementTypeOther[@name="Channels"]'
        @followed_channel = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeCollectionView[1]/XCUIElementTypeCell[2]'
      end
    end
  end
end

module Kernel
  def following_page
    Pages::FollowingPage
  end
end
