module Pages
  module GameDirectory
    class << self

      attr_accessor :games_directory, :top_game, :chromecast_text, :chromecast_okay, :top_game_channel, :game_nav_bar,
                    :last_game, :next_page_game, :nav_bar

      def dismiss_chromecast
        if xpath(chromecast_text).displayed?
          xpath(chromecast_okay).click
        end
      end

      def initialize_ios_game_directory_variables

        # Accessible via left nav
        @games_directory ='//XCUIElementTypeStaticText[@name="Games"]'

        # Chromecast checks
        @chromecast_text = '//XCUIElementTypeStaticText[@name="Touch to cast Twitch streams to your TV"]'
        @chromecast_okay = '//XCUIElementTypeButton[@name="Okay"]'

        # Accessible via Games Directory
        @top_game = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeCollectionView[1]/XCUIElementTypeCell[1]'
        @top_game_channel = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeTable[1]/XCUIElementTypeCell[1]'
        @last_game = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeCollectionView[1]/XCUIElementTypeCell[6]'
        @next_page_game = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeCollectionView[1]/XCUIElementTypeCell[7]'

        # Top navigation bar
        @game_nav_bar = '//XCUIElementTypeNavigationBar[@name="Games"]'
        @nav_bar = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeNavigationBar[1]'

      end

    end
  end
end

module Kernel
  def game_directory
    Pages::GameDirectory
  end
end
