module Pages
  module LoginPage
    class << self

      attr_accessor :left_nav_login_element, :username_field, :password_field, :login_button, :logged_in_username,
                    :logout_button, :logout_confirmation, :experiments, :captcha_toggle, :experiment_done_button

      # Need to make login more dynamic later.

      def nav_login(username)
        disable_captcha

        wait{xpath(left_nav_login_element).click}

        wait{xpath(username_field).click}

        xpath(username_field).send_keys(username)

        wait{xpath(password_field).click}
        xpath(password_field).send_keys("L3tsTw1tch")
        xpath(login_button).click

        wait{xpath(login_page.logged_in_username)}
      end

      def logout
        open_nav

        wait{xpath(logout_button).click}
        alert_accept
      end

      # Leads to clicking the switch that sets the passport_trusted_request cookie to bypass CAPTCHA
      def disable_captcha
        wait{xpath(experiments).click}

        wait{xpath(captcha_toggle).displayed?}
        wait{xpath(captcha_toggle).click}
        xpath(experiment_done_button).click
      end

      def initialize_ios_login_variables

        # Contained within left nav
        @left_nav_login_element = '//XCUIElementTypeButton[@name="Log In"]' # Login button contained within left nav
        @my_user_left_nav = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeTable[1]/XCUIElementTypeCell[1]'

        # Contained within passport webview
        @username_field = '//XCUIElementTypeOther[@name="Username"]'
        @password_field = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[6]/XCUIElementTypeSecureTextField[1]'
        @login_button = '//XCUIElementTypeButton[@name="Log In"]'

        # Username/button leading to profile contained within left nav
        @logged_in_username = '//XCUIElementTypeApplication[1]/XCUIElementTypeWindow[1]/XCUIElementTypeOther[1]/XCUIElementTypeOther[2]/XCUIElementTypeOther[1]/XCUIElementTypeOther[1]/XCUIElementTypeTable[1]/XCUIElementTypeCell[1]/XCUIElementTypeStaticText[1]'
        @logout_button = '//XCUIElementTypeButton[@name="Logout"]'
        @logout_confirmation = '//XCUIElementTypeStaticText[@name="Are you sure you want to log out?"]'
        @experiments = '//XCUIElementTypeButton[@name="Experiments"]' # Experiments button in left nav of Xarth app

        # UI Elements contained within Experiments page
        @captcha_toggle = '//XCUIElementTypeSwitch[@name="Captchas disabled"]'
        @experiment_done_button = '//XCUIElementTypeButton[@name="Done"]'
      end
    end
  end
end

module Kernel
  def login_page
    Pages::LoginPage
  end
end
