require_relative 'requires'

describe 'User can use chat to' do

  it 'chat on live video' do

    # Login then visit a test channel to see chat entries
    username = 'qa_moba'
    login_page.nav_login(username)

    open_nav

    channel_page.visit_test_channel

    wait{expect(xpath(chat_page.chat_text_area).displayed?).to be_true}

    # Wait until chat connects
    within (xpath(chat_page.chat_container)) do
      wait{expect(xpath(chat_page.chat_progress_spinner).displayed?).to be_false}
    end

    # Enter and verify test text is displaying in chat text area
    xpath(chat_page.chat_text_area).click
    xpath(chat_page.chat_text_area).send_keys 'test text'
    xpath(chat_page.chat_text_area).send_keys :enter
    xpath(chat_page.chat_area).click
    wait{expect(xpath(chat_page.chat_text).displayed?).to be_true}
    login_page.logout
  end

  it 'view chat on live video' do
    channel_page.visit_top_channel
    wait{expect(xpath(chat_page.chat_title).displayed?).to be_true}
  end
end
