require_relative 'requires'

describe 'Channels Directory' do

  it 'loads correctly' do
    wait{xpath(channel_directory.channels_directory).displayed?}
    xpath(channel_directory.channels_directory).click
    wait{xpath(channel_directory.channels_nav_bar).displayed?}
    expect(xpath(channel_directory.channels_nav_bar).displayed?).to be_true
    expect(xpath(channel_directory.top_channel).displayed?).to be_true
    expect(xpath(channel_directory.next_page_channel).displayed?).to be_false
    expect(xpath(channel_directory.last_channel).displayed?).to be_true
  end

  it 'Can tap on a channel' do
    channel_page.visit_top_channel
    wait{expect(xpath(channel_page.channel_activity).displayed?).to be_true}
  end
end

describe 'Games Directory' do

  it 'loads correctly' do
    xpath(game_directory.games_directory).click
    expect(xpath(game_directory.game_nav_bar).displayed?).to be_true
    expect(xpath(game_directory.top_game).displayed?).to be_true
    expect(xpath(game_directory.last_game).displayed?).to be_true
    expect(xpath(game_directory.next_page_game).displayed?).to be_false
  end

  it 'Can tap on a game' do
    xpath(game_directory.games_directory).click
    top_game_name = xpath(game_directory.top_game).name
    xpath(game_directory.top_game).click
    wait{xpath(game_directory.nav_bar).displayed?}
    expect(top_game_name).to eq(xpath(game_directory.nav_bar).name)
  end

  it 'Can tap on a channel' do
    xpath(game_directory.games_directory).click
    wait{xpath(game_directory.top_game).displayed?}
    xpath(game_directory.top_game).click
    wait{xpath(game_directory.top_game_channel).displayed?}
    xpath(game_directory.top_game_channel).click
    wait{expect(xpath(channel_page.channel_activity).displayed?).to be_true}
  end
end
