# UI testing with Appium

### Setup Appium Environment

##### XCode

Install latest [Xcode](https://developer.apple.com/xcode/downloads/) from app store.

Install [Xcode Command Line Tools](https://developer.apple.com/download/more/), or within Xcode: (Xcode > Preferences > Downloads).

##### Java

Install latest [Java](http://www.oracle.com/technetwork/java/javase/downloads/index.html).

##### Homebrew

Follow instructions at http://brew.sh/, copied below.

```shell
ruby -e "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/master/install)"
brew doctor
brew update && brew upgrade
```

Edit your path to prefer `/usr/local/bin` if it doesn't already by adding:

```shell
export PATH="/usr/local/bin":$PATH
```

to your `~/.bash_profile`. Alternatively: `echo 'export PATH="/usr/local/bin":$PATH' >> ~/.bash_profile`

##### Git

At the time of writing, the version of Git that came with OSX had a major [security vulnerability](https://github.com/blog/1938-vulnerability-announced-update-your-git-clients).

```shell
brew install git
```


##### Rbenv and ruby-build

```shell
brew install rbenv ruby-build
```

Add rbenv eval to your `~/.bash_profile`

```shell
echo 'eval "$(rbenv init -)"' >> ~/.bash_profile
```

Source your profile

```shell
source ~/.bash_profile
```

##### Clone qa/moba

It's recommended if you're just joining Twitch, to have a folder for all Twitch repositories. You can also create directories per organization.

```shell
mkdir p ~/twitch/qa
cd ~/twitch/qa
git clone git@git-aws.internal.justin.tv:qa/moba.git
cd moba
```
The new directory structure for Moba will be `~/twitch/qa/moba`

##### Install Ruby

We're currently running Ruby 2.3.0.

*NOTE:* You shouldn't run any of these commands with `sudo`. If you do, the following steps will break. Make sure to run these commands from within your moba directory.

```shell
rbenv install `cat .ruby-version`
rbenv rehash
```

Verify rbenv set the correct Ruby Version

```
ruby -v
```

##### Update RubyGems and Bundler.

```
gem update --system
gem install bundler -v 1.14.6
rbenv rehash
```

Check RubyGems is >= 2.1.5.

```
gem --version
```

##### Install Gems

`bundle install`

##### Install Other Dependencies

Install nodejs, using brew.
```
brew update
brew install node
```
Node should be v-.10.26 or better.
```
node --version
npm --version
```
Install grunt.
```
npm install grunt
npm install -g grunt grunt-cli
```
Verify grunt and grunt-cli versions from the appium folder.
```
grunt --version
```

Install ant.
```
brew install ant
```
Install maven 3.1.1 or better.
```
brew install maven
```
Install Appium

```
npm install -g appium@1.6.4
```

Install Appium-Doctor
```
npm install -g appium-doctor
appium-doctor
```

Appium Doctor will check for Appium dependencies. Typically the user will need to set some of these
within their ~/.bash_profile. After this point in setup, we will likely have to set the following in
~/.bash_profile:

```
export JAVA_HOME="`/System/Library/Frameworks/JavaVM.framework/Versions/Current/Commands/java_home`"
export PATH=$PATH:$JAVA_HOME/bin
```

#### For setup reference:

http://appium.io/slate/en/tutorial/android.html?ruby#install-ruby

IDE for test case development:

[Rubymine IDE](https://www.jetbrains.com/ruby/)

[Atom] (https://atom.io/)

### Android env setup

##### Install Android SDK and Tools

[Download Android Studio](https://developer.android.com/studio/index.html)

Install Latest SDK and Tools

1) Open Android Studio

2) Click Configure > SDK Manager

3) Appearance & Behavior > System Settings > Android SDK

4) Select Latest Android version

5) Click SDK Tools

6) Make sure Intel x86 Emulator Accelerator is selected.

##### Create Android Virtual Device

1) Open Android Studio

2) Navigate to Tools > Android > AVD Manager

3) Create Virtual Device

4) Select a recent device > Next

5) Choose latest Android Version > Next

6) Select name `moba_test` and all other default settings > Finish

We will need to update our ~/.bash_profile here with the ANDROID_HOME, adb, android, emulator:
```
export ANDROID_HOME=/Users/<home_directory>/Library/Android/sdk
export ANDROID_SDK=$ANDROID_HOME

export PATH=$ANDROID_HOME/platform-tools:$PATH
export PATH=$ANDROID_HOME/tools:$PATH
```

[Twitch Mobile Team - Building the Android App](https://twitchtv.atlassian.net/wiki/display/ENG/Building+the+Android+App)

### iOS env setup

##### Install Carthage
Web Driver Agent requires Carthage dependency manager

`brew install carthage`

##### Install iPhone Simulator

1) Open XCode

2) Navigate to Xcode -> Preferences -> Components

3) Download iOS Simulator 10.0


[Twitch Mobile Team - Building the iOS App](https://twitchtv.atlassian.net/wiki/display/ENG/Building+the+iOS+App)

Build locally for ad-hoc distribution:
`fastlane ios xarth_ad_hoc`

This will build the app for ad-hoc distribution, allowing us to easily install it on any of our various devices. However, this is meant for physical devices, not virtual devices. We have a Xarth.ipa and a Xarth.app version of the iOS app. In order to install the app on a virtual device (simulator), we have to use Xarth.app file, which is located:

```
/developer/xcode/deriveddata/<twitch_folder>/build/products/Debug-iphonesimulator
```

##### App Location
In order to standardize app directories with Moba, we're storing the app within the Moba repo.

Create app directory for Android
```
cd ~/twitch/qa/moba/android
mkdir app
```

Create app directory for iOS
```
cd ~/twitch/qa/moba/ios
mkdir app
```

Move app files into their corresponding app directories for proper setup.

### To Start Appium Server
Run
```
appium
```

### To Run tests on Android/iOS
1) `cd ~/twitch/qa/moba/android` or `cd ~/twitch/qa/moba/ios`

2) `bundle exec rspec`

### To launch virtual device via terminal
1) `cd ~/twitch/qa/moba/android` or `cd ~twitch/qa/moba/ios`

2) `arc`

### To launch appium inspector
1) `cd moba`

2) `open -a appium`

3) Click Magnifying glass icon in the Appium GUI

### To reset
`cd appium; ./reset.sh`

#### Reset By Platform
`./reset.sh --ios`

`./reset.sh --android`



### Helpful Docs
https://github.com/appium/ruby_lib/blob/master/docs/android_docs.md

http://appium.io/slate/en/v1.0.0/?ruby#appium-client-libraries

## Writing Tests

#### Pre-requisites:
- Clone moba repo
- Verify that you can launch virtual device via terminal
    - Android:
        - `cd ~/twitch/qa/moba/android`
        - `arc`
    - iOS:
        - `cd ~/twitch/qa/moba/ios`
        - `arc`
- Create an appium.txt file in both, Android and iOS directories. This will set the capabilies of the device where tests are running.
    - Android
        ```
        [caps]
        platformNmae = "android"
        app = "<app_path>"
        deviceName = "Android"
        avd = "<avd_name>"
        platformVersion = "<android_os_version>"
        ```
    - iOS
        ```
        [caps]
        platformName = "ios"
        app = "<app_path>"
        deviceName = "<device_for_testing>"
        ```

We will be using xpaths and resource-ids in order to interact with elements on screen. We are looking to grab elements by their element name or accessibiltiy id:

iOS:
- `left_nav_login_element = xpath('//XCUIElementTypeButton[@name="Log In"]')`

Android:
- `left_nav_login_element = 'tv.twitch.android.debug:id/login_button'`
