class ChannelPage

  @play_button = '.js-control-play-button'
  @loading_attr = 'data-loading'
  @player_holder = '.player-holder'
  @iframe = 'iframe'
  @player = '.player'

  class << self

    include Capybara::DSL

    attr_reader :play_button, :loading_attr, :player_holder, :iframe, :player,
                :player_loading

    def player_frame
      within @player_holder do
        return find(@iframe)
      end
    end

    def player_loading?
      within_frame player_frame do
        find(@play_button).click
        if find(@player)[@loading_attr] == "true"
          return true
        end
      end
    end
  end
end
