require 'capybara/dsl'
require './pages/channel_page'

class PlayerUI

  @play_button = '.js-control-play-button'
  @player = '.player'
  @loading_attr = 'data-loading'
  @player_fullscreen_overlay = '.js-control-fullscreen-overlay'
  @play_pause_button = '.js-control-playpause-button'
  @paused_attr = 'data-paused'
  @fullscreen_button = '.js-control-fullscreen'
  @fullscreen_attr = 'data-isfullscreen'

  class << self

    include Capybara::DSL

    attr_reader :play_button, :player_fullscreen_overlay, :play_pause_button

    def player_loading?
      within_frame ChannelPage.player_frame do
        return find(@player)[@loading_attr] == "true"
      end
    end

    def paused?
      find(@play_button).click
      return find(@player)[@paused_attr] == "true"
    end

    def player_fullscreen?
      find(@fullscreen_button).click
      return find(@player)[@fullscreen_attr] == "true"
    end
  end
end
