require './pages/channel_page'
require './pages/directory_page'
require '../common/spec_helper'

describe 'Channel Page' do

  it 'can be accessed via directory' do
    visit '/'
    first(DirectoryPage.directory_item_css).click # Games directory
    expect(page).to have_css(DirectoryPage.channel_directory)

    first(DirectoryPage.directory_item_css).click # Channels directory
    expect(page).to have_css(ChannelPage.player_holder)
  end
end

describe 'Channel page player' do

  before(:each) do
    visit '/monstercat'
  end

  it 'player loads' do
    within_frame(ChannelPage.player_frame) do
      find(ChannelPage.play_button).click
      expect(page).not_to have_css(ChannelPage.play_button)
    end
  end

  it 'player loads stream' do
    expect(ChannelPage.player_loading?).to be true
  end
end
