require './class/data_writer.rb'
require './class/jenkins_connection.rb'
require './class/data_presenter.rb'

puts 'Welcome to the Smoca Metric Tool (BETA). What job do you want to analyze?'
puts "\t1: web-web-deploy"
puts "\t2: qa-smoca"

print 'Your Selection: '
job_input = gets.chomp.to_i

case job_input
when 1
  job = 'web-web-deploy'
when 2
  job ='qa-smoca'
else
  raise 'Error. Invalid input. Quitting...'
end

j = JenkinsConnection.new(job)

puts 'How many builds would you like to analyze?'

print '# of Builds: '

number_of_builds_to_search = gets.chomp.to_i

builds = j.compile_build_data(number_of_builds_to_search, "#{job}.csv")

data = DataPresenter.new(builds, job)

puts "\nDatabase Loaded."
input = nil


while input != 5
  puts 'What report would you like to see?'
  puts "\t1: Environment Report"
  puts "\t2: Developer Report"
  puts "\t3: Log"
  puts "\t4: Date Report"
  puts "\t5: Exit"

  print 'Your Selection: '
  input = gets.chomp

  puts "\n---------------\n"

  case input
  when '1'
    data.print_environment_report
  when '2'
    data.print_developer_report
  when '3'
    data.print_log
  when '4'
    data.print_date_report
  else
    break
  end

  puts "\n---------------\n\n"
end
