class DataPresenter
  def initialize(data, job)
    @app_environments = {}
    @developers = {}
    @dates = {}
    @data = data

    @data.each do |build|
      next if build['initiatedBy'].nil?

      if build['smoca_triggered'].nil? && job == 'qa-smoca'
        # People who trigger directly from Smoca wont have the smoca_triggered parameter.
        # Manually add it, since if the job is qa-smoca it's obvious they triggered it
        build['smoca_triggered'] = true
      end

      analyze_environments(build)
      analyze_developers(build)
      analyze_dates(build)
    end
  end

  def analyze_environments(build)
    smoca_trigger = build['smoca_triggered'].to_s.to_sym
    environment = build['environment'].gsub(/[-]/, '_').to_sym

    if @app_environments.has_key?(environment)
      if @app_environments[environment].has_key?(smoca_trigger)
        @app_environments[environment][smoca_trigger] = @app_environments[environment][smoca_trigger] + 1
      else
        @app_environments[environment][smoca_trigger] = 1
      end
    else
      @app_environments[environment] = {:true => 0, :false => 0}
      @app_environments[environment][smoca_trigger] = @app_environments[environment][smoca_trigger] + 1
    end
  end

  def analyze_developers(build)
    developer_ldap = build['initiatedBy'].gsub(/[-]/, '_').to_sym
    smoca_trigger = build['smoca_triggered'].to_s.to_sym

    if @developers.has_key?(developer_ldap)
      if @developers[developer_ldap].has_key?(smoca_trigger)
        @developers[developer_ldap][smoca_trigger] = @developers[developer_ldap][smoca_trigger] + 1
      else
        @developers[developer_ldap][smoca_trigger] = 1
      end
    else
      @developers[developer_ldap] = {:true => 0, :false => 0}
      @developers[developer_ldap][smoca_trigger] = @developers[developer_ldap][smoca_trigger] + 1
    end
  end

  def analyze_dates(build)
    smoca_trigger = build['smoca_triggered'].to_s.to_sym
    date_key = build['date']

    if @dates.has_key?(date_key)
      if @dates[date_key].has_key?(smoca_trigger)
        @dates[date_key][smoca_trigger] = @dates[date_key][smoca_trigger] + 1
      else
        @dates[date_key][smoca_trigger] = 1
      end
    else
      @dates[date_key] = {:true => 0, :false => 0}
      @dates[date_key][smoca_trigger] = @dates[date_key][smoca_trigger] + 1
    end
  end


  def print_developer_report
    print 'Sort? (y/n): '
    input = gets.chomp

    if input.downcase == 'y'
      sorted = @developers.sort_by { |k, v| (percentage_calculator(v[:true], v[:false]))}

      sorted.each do |x|
        dev = x[0]
        smoca_ran = x[1][:true]
        not_ran = x[1][:false]

        percentage_ran = percentage_calculator(smoca_ran, not_ran)

        puts "Developer: #{dev}\n\tTrue: #{smoca_ran}\n\tFalse:#{not_ran}\n\tPercentage Ran: #{percentage_ran}%\n"
      end
    else
      @developers.each do |key, value|
        smoca_ran = value[:true]
        not_ran = value[:false]

        percentage_ran = percentage_calculator(smoca_ran, not_ran)

        puts "Developer: #{key}\n\tTrue: #{value[:true]}\n\tFalse:#{value[:false]}\n\tPercentage Ran: #{percentage_ran}%\n"
      end
    end
  end

  def print_environment_report
    @app_environments.each do |key, value|
      smoca_ran = value[:true]
      not_ran = value[:false]

      percentage_ran = percentage_calculator(smoca_ran, not_ran)

      puts "Environment: #{key}\n\tTrue: #{value[:true]}\n\tFalse:#{value[:false]}\n\tPercentage Ran: #{percentage_ran}%\n"
    end
  end

  def print_date_report
    @dates.each do |key, value|
      smoca_ran = value[:true]
      not_ran = value[:false]

      percentage_ran = percentage_calculator(smoca_ran, not_ran)

      puts "Date: #{key}"
      puts "\tTimes Ran: #{smoca_ran}"
      puts "\tTimes Not Ran: #{not_ran}"
      puts "\tPercentage Ran: #{percentage_ran}%"
    end
  end

  def percentage_calculator(val1, val2)
    return ((val1.to_f / (val1.to_f + val2.to_f)) * 100).round(2)
  end

  def print_log
    @data.each do |build|
      print "\n"
      puts "#{build['buildName']} (#{build['buildResult']})"
      puts "\tInitiated By: #{build['initiatedBy']}" unless build['initiatedBy'].nil?
      puts "\tDate: #{build['date']}"
      puts "\tEnvironment: #{build['environment']}"
      puts "\tSmoca Initiated: #{build['smoca_triggered']}" unless build['smoca_triggered'].nil?
    end
  end
end
