# 301 Redirect
Thanks for the memories, Smoca


---
[Documentation Home](resources/docs) | [Trigger Regression Tests][Smoca Job] | [On-Call Runbook](resources/docs/on_call_runbook/README.md)

- - -

Smoca is a Black-box GUI automated test suite developed and maintained by QA. It includes over 100 scenarios that focus on what the user sees and how they interact with Twitch.

## Table of Contents
- [UI testing with Capybara](#ui-testing-with-capybara)
- [Using Smoca for Web](#using-smoca-for-web)
- [Using Smoca for Video Player](#using-smoca-for-video-player)
- [Contributing To Smoca](#contributing-to-smoca)
- [Resources](#resources)

## UI testing with Capybara

##### What is a Black-box UI Automated Test?
User interface automated tests make sure the website is functioning as intended. Services such as login, page loading, and proper interaction with elements can be confirmed with these tests.

These tests are not unit or integration tests. They examine the application without focusing on the internal code, as if a user was using the application.

##### What is Capybara?
Capybara is a high level integration testing framework that abstracts the webdriver and browser. It is written in Ruby.

## Using Smoca for Web

Smoca can be used to test against your branch and staging environment. Here's how to do it:

#### Via The Deploy Tool (Recommended)
It's possible to trigger Smoca directly from The Deploy Tool (Skadi) within certain repositories.

See documentation for [Skadi Integration](resources/docs/skadi_integration.md).

#### Via Dashboard (Recommended)
1. Deploy your branch to a staging environment
2. Navigate to https://smoca.internal.justin.tv/run
3. Select your staging environment, browser and operating system you'd like tests to run against
4. Click Start Build

#### Locally
Follow [Developing For Smoca Documentation][Developing For Smoca] to set up your environment.

When in root of folder, you can run:

`bundle exec rake`

You can supply a specific spec to run like so:

`bundle exec rspec spec/web/front_page_spec.rb`

You can even narrow it down to the specific scenario, by supplying the line number the scenario starts on, like so:

`bundle exec rspec spec/web/front_page_spec.rb:15`

These commands will run all tests. You can provide the Twitch environment (a staging box, production, or local) prefacing with `ENVIRONMENT=<environment>` like so:

`ENVIRONMENT=staging-ffa-15 bundle exec rspec`

There are various different environment variables you can provide. See [Environment Variable Documentation](resources/docs/environment_variables.md).

**Note for Testing Against Localhost:**

Smoca has not been tested against Localhost. If your localhost connection is loading too slow, Smoca may time out on page load.

## Using Smoca for Video Player

Smoca can be used to test against your branch and staging environment. Here's how to do it:

#### Locally (Firefox & Chrome Only)
Follow [Developing For Smoca Documentation][Developing For Smoca] to set up your environment. Smoca currently supports two test suites for Video Player: player_ui or player_core. To run locally, configure the `video_player_config.yaml` properties file to contain `GRID: false`, additionally, it can also be specified via command line as `GRID=false`.

When in root of folder, to run all test in a specific TEST_SUITE (ie. player_ui) you can run:

`PROPERTIES=video_player_config.yaml TEST_SUITE=player_ui bundle exec rake`

You can supply a specific spec to run like so:

`PROPERTIES=video_player_config.yaml bundle exec rspec spec/video/player_ui/stream/playback_spec.rb`

You can even narrow it down to the specific scenario, by supplying the line number the scenario starts on, like so:

`PROPERTIES=video_player_config.yaml bundle exec rspec spec/video/player_ui/stream/playback_spec.rb:10`

The config file, `video_player_config.yaml` contains default test suite configurations. You can provide specific parameters by either configuring `video_player_config.yaml` or overriding the file by adding parameters such as, `PLAYER_ENVIRONMENT=betaplayer` directly to the command line. For example:

`PROPERTIES=video_player_config.yaml PLAYER_ENVIRONMENT=betaplayer bundle exec rspec`

#### Grid (Win 10 - Firefox or Win10 - Chrome)
To run on grid, configure the `video_player_config.yaml` properties file to contain `GRID: true`, additionally, it can also be specified via command line as `GRID=true`. As of 04/05/2018, grid only supports Windows 10 nodes for both video player test suites. To specify which browser to use, configure the `video_player_config.yaml` properties file to contain 'BROWSER: firefox, additionally, it can also be specified via command line as `BROWSER=firefox`*[]: 


**Note:**

* Specifying `TEST_SUITE` on command line is required if executing `rake`.

* The default `video_player_config.yaml` file contains all required parameters for running a video player test for either given TEST_SUITE. Smoca for video player will prioritize command line configurations over those found in a properties file. There are various different environment variables you can provide. See [Environment Variable Documentation](resources/docs/environment_variables.md).


### Getting Results
#### Via Jenkins

##### Automatic Slack Notifications (Smoca For Web Only)
Following a build, Smoca will deliver the result via Slack DM.

If you triggered a build [via the deploy tool](resources/docs/skadi_integration.md), Smoca will use your LDAP Username. It expects your Slack email to match `ldap@justin|twitch.tv`.

If you triggered via Jenkins, you'll want to make sure your Jenkins Full Name is set in Jenkins' settings, and it matches your Slack Full Name.

Steps to change your Jenkins Full Name:

1. Go to [Jenkins](http://jenkins-master-0.prod.us-west2.justin.tv/)
2. Click your name in the top right
3. Click Configure

##### Console Logs
Failures are typically outputted at the bottom of the log. To access the console log:

1. Go to the [Jenkins QA-Smoca Project][Smoca Job]
2. Click the build number
3. Click Console Output

See [Understanding Test Output](resources/docs/understanding_test_output.md) for more details.

### Failed Tests
#### What do I do when my test fails?
Try to replicate the reported issue manually.

See [Debugging Failed Tests](resources/docs/understanding_test_output.md#debugging_failed_tests) for more information.

If you can't replicate the problem, and are having trouble understanding the root cause, [contact us](#contact).

A failed test will not prevent someone from pushing code to an environment.

## Contributing to Smoca

See [Developing For Smoca][Developing For Smoca] for documentation on how to set up your environment and write tests.

Test it locally & open a PR on Github.

## Resources
### Coverage
For a list of tests are running, or about to be run, please visit [this Google Doc](https://docs.google.com/a/justin.tv/spreadsheets/d/1fVnLnQDYZaLZpEjtC9QDsv-saMyzDmnLQ5LEgXe-m-c/edit?usp=sharing).

### Additional Documentation
There are multiple documentation resources available in [resources/docs](resources/docs). Here are a few important ones:

- [Developing for Smoca](resources/docs/developing_for_smoca.md)
- [Framework Structure](resources/docs/framework_structure.md)
- [Understanding Test Output](resources/docs/understanding_test_output.md)

### Contact
Email: qa-automation@twitch.tv

Slack: #qa-automation

[Smoca Job]: https://smoca.internal.justin.tv/run
[Developing For Smoca]: resources/docs/developing_for_smoca.md
